/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Rectangle;
import java.util.Date;

public class DayNight119
extends Applet {
    String versStr = "  - v 1.19";
    Date dat;
    int year;
    int month;
    int date;
    int day;
    int hours;
    int minutes;
    int seconds;
    Image bild;
    String[] dayArray = new String[7];
    String[] monthArray = new String[12];
    Graphics g;
    Button button;
    public DNloc115 time;
    public Choice timeChoice;
    public String timeString;
    public int locOffset;
    int browserOffset;
    int xMouse = 0;
    int yMouse = 0;
    int xOben = 40;
    int xL = 20;
    double latitude;
    double longitude;
    double dec;
    double GHA;
    double hoehe = 0.0;
    double K = Math.PI / 180;
    boolean clicked;

    public double computeDeclination(int T, int M, int J, double STD) {
        long N = 365 * J + T + 31 * M - 46;
        N = M < 3 ? (N += (long)((J - 1) / 4)) : N - (long)((int)(0.4 * (double)M + 2.3)) + (long)((int)((double)J / 4.0));
        double X = (double)(N - 693960L) / 1461.0;
        X = (X - (double)((int)X)) * 1440.02509 + (double)((int)X) * 0.0307572;
        X = X + STD / 24.0 * 0.9856645 + 356.6498973;
        X += 1.91233 * Math.sin(0.9999825 * X * this.K);
        X = (X + Math.sin(1.999965 * X * this.K) / 50.0 + 282.55462) / 360.0;
        X = (X - (double)((int)X)) * 360.0;
        double J2000 = (double)(J - 2000) / 100.0;
        double Ekliptik = 23.43929111 - (46.815 + (5.9E-4 - 0.001813 * J2000) * J2000) * J2000 / 3600.0;
        X = Math.sin(X * this.K) * Math.sin(this.K * Ekliptik);
        return Math.atan(X / Math.sqrt(1.0 - X * X)) / this.K + 7.5E-4;
    }

    public double computeGHA(int T, int M, int J, double STD) {
        long N = 365 * J + T + 31 * M - 46;
        N = M < 3 ? (N += (long)((J - 1) / 4)) : N - (long)((int)(0.4 * (double)M + 2.3)) + (long)((int)((double)J / 4.0));
        double P = STD / 24.0;
        double X = (P + (double)N - 722449.0) * 0.98564734 + 279.306;
        double XX = -104.55 * Math.sin(X *= this.K) - 429.266 * Math.cos(X) + 595.63 * Math.sin(2.0 * X) - 2.283 * Math.cos(2.0 * X);
        XX = XX + 4.6 * Math.sin(3.0 * X) + 18.7333 * Math.cos(3.0 * X);
        XX = XX - 13.2 * Math.sin(4.0 * X) - Math.cos(5.0 * X) - Math.sin(5.0 * X) / 3.0 + 0.5 * Math.sin(6.0 * X) + 0.231;
        XX = XX / 240.0 + 360.0 * (P + 0.5);
        if (XX > 360.0) {
            XX -= 360.0;
        }
        return XX;
    }

    public double computeHeight() {
        double sinHeight = Math.sin(this.dec * this.K) * Math.sin(this.latitude * this.K) + Math.cos(this.dec * this.K) * Math.cos(this.K * this.latitude) * Math.cos(this.K * (this.GHA + this.longitude));
        double height = Math.asin(sinHeight);
        return height /= this.K;
    }

    public double computeAzimut() {
        double cosAz = (Math.sin(this.dec * this.K) - Math.sin(this.latitude * this.K) * Math.sin(this.hoehe * this.K)) / (Math.cos(this.hoehe * this.K) * Math.cos(this.K * this.latitude));
        double Az = 1.5707963267948966 - Math.asin(cosAz);
        Az /= this.K;
        if (Math.sin(this.K * (this.GHA + this.longitude)) < 0.0) {
            // empty if block
        }
        if (Math.sin(this.K * (this.GHA + this.longitude)) > 0.0) {
            Az = 360.0 - Az;
        }
        return Az;
    }

    public void myDayMonth() {
        this.dayArray[0] = "Sunday";
        this.dayArray[1] = "Monday";
        this.dayArray[2] = "Tuesday";
        this.dayArray[3] = "Wednesday";
        this.dayArray[4] = "Thursday";
        this.dayArray[5] = "Friday";
        this.dayArray[6] = "Saturday";
        this.monthArray[0] = "January";
        this.monthArray[1] = "February";
        this.monthArray[2] = "March";
        this.monthArray[3] = "April";
        this.monthArray[4] = "May";
        this.monthArray[5] = "June";
        this.monthArray[6] = "July";
        this.monthArray[7] = "August";
        this.monthArray[8] = "September";
        this.monthArray[9] = "October";
        this.monthArray[10] = "November";
        this.monthArray[11] = "December";
    }

    public void init() {
        this.myDayMonth();
        this.bild = this.getImage(this.getDocumentBase(), "applet/map.gif");
        this.dat = new Date();
        Rectangle r = this.bounds();
        Image picture = this.createImage(r.width, r.height);
        this.g = picture.getGraphics();
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(this.bild, 0);
        try {
            tracker.waitForID(0);
        }
        catch (Exception exception) {}
        Panel panel = new Panel();
        this.add("Buttons", panel);
        this.add("Choice", panel);
        this.time = new DNloc115();
        this.timeChoice = new Choice();
        this.time.timeMenu(this.timeChoice);
        panel.add(this.timeChoice);
        this.button = new Button();
        this.button.setLabel("update time");
        panel.add(this.button);
        this.dat = new Date();
        this.browserOffset = this.dat.getTimezoneOffset();
        this.locOffset = this.browserOffset = -this.browserOffset / 60;
        this.timeString = String.valueOf(this.browserOffset) + " h";
        if (this.browserOffset > 0) {
            this.timeString = "+" + this.timeString;
        }
        this.timeChoice.select(this.timeString);
        this.resize(this.size().width, this.size().height);
        this.clicked = false;
    }

    public int computeLat(int longitude, double dec) {
        double tan = -Math.cos((double)longitude * this.K) / Math.tan(dec * this.K);
        double itan = Math.atan(tan);
        return (int)Math.round(itan /= this.K);
    }

    public void paint(Graphics g) {
        double equation;
        double diff;
        int min;
        int x0 = 180;
        int y0 = 90 + this.xOben;
        int left = 370 + this.xL;
        int Radius = 6;
        g.setFont(new Font("Helvetica", 0, 9));
        g.drawString("Day & Night Applet" + this.versStr, left - 30, 245);
        g.drawString("\u00a9 1998-1999 Juergen Giesen", left - 30, 260);
        g.drawString("www.sweethome.de/giesen/", left - 30, 275);
        Font f = new Font("Helvetica", 0, 10);
        g.setFont(f);
        g.drawImage(this.bild, this.xL, this.xOben, this);
        g.drawRect(this.xL, this.xOben, 360, 178);
        g.drawString("Applet's Time Zone Offset is ", this.xL, this.xOben - 15);
        this.dat = new Date();
        String str = this.dat.toString();
        g.drawString(str, this.xL, 245);
        this.day = this.dat.getDay();
        g.drawString(this.dayArray[this.day], left, 60);
        this.date = this.dat.getDate();
        this.month = this.dat.getMonth();
        str = String.valueOf(this.monthArray[this.month]) + " " + String.valueOf(this.date) + ", ";
        this.year = this.dat.getYear();
        str = String.valueOf(str) + " 19" + this.year;
        g.drawString(str, left, 80);
        this.hours = this.dat.getHours();
        g.drawString(String.valueOf(this.hours) + " Hours", left, 100);
        this.minutes = this.dat.getMinutes();
        g.drawString(String.valueOf(this.minutes) + " Minutes", left, 120);
        this.seconds = this.dat.getSeconds();
        g.drawString(String.valueOf(this.seconds) + " Seconds", left, 140);
        double STD = (double)(this.hours - this.locOffset) + (double)this.minutes / 60.0 + (double)this.seconds / 3600.0;
        this.dec = this.computeDeclination(this.date, this.month + 1, this.year + 1900, STD);
        str = String.valueOf((double)Math.round(100.0 * this.dec) / 100.0);
        String s = str.substring(0, str.indexOf(".") + 2);
        g.setColor(Color.blue);
        g.drawString("Declin.=" + s + " degs", left, 160);
        this.GHA = this.computeGHA(this.date, this.month + 1, this.year + 1900, STD);
        str = String.valueOf((double)Math.round(10.0 * this.GHA) / 10.0);
        s = str.substring(0, str.indexOf(".") + 2);
        g.drawString("GHA =    " + s + " degs", left, 175);
        double GHA12 = this.computeGHA(this.date, this.month + 1, this.year + 1900, 12.0);
        if (GHA12 > 5.0) {
            GHA12 -= 360.0;
        }
        str = (min = (int)Math.round((diff = Math.abs((equation = GHA12 * 4.0) - (double)((int)equation))) * 60.0)) > 9 ? ":" : ":0";
        g.drawString("Equation of Time", left, 190);
        g.drawString("       = " + (int)equation + str + min + " min", left, 203);
        g.setColor(Color.black);
        str = this.browserOffset > 0 ? "+" : "";
        g.drawString("Browser's Time Zone Offset is " + str + this.browserOffset + " h", this.xL, 275);
        this.hours = this.dat.getHours() - this.locOffset;
        this.timeString = String.valueOf(this.locOffset) + " h";
        if (this.hours < 0) {
            this.hours += 24;
        }
        if (this.hours >= 24) {
            this.hours -= 24;
        }
        str = this.minutes > 9 ? ":" : ":0";
        str = String.valueOf(this.hours) + str + this.minutes;
        s = this.seconds > 9 ? ":" : ":0";
        str = String.valueOf(str) + s + this.seconds;
        g.setColor(Color.blue);
        g.drawString(String.valueOf(str) + " GMT", this.xL, 260);
        g.setColor(Color.red);
        int x = x0 - (int)Math.round(this.GHA);
        if (x < 0) {
            x += 360;
        }
        if (x > 360) {
            x -= 360;
        }
        int xx = this.xL;
        g.setColor(Color.gray);
        g.drawLine(this.xL, y0, this.xL + 2 * x0 - 2, y0);
        g.drawLine(this.xL + x0, y0 - 90, this.xL + x0, y0 + 90);
        int yy1 = (int)Math.round((double)y0 - 23.5);
        int yy2 = (int)Math.round((double)y0 + 23.5);
        int y = (int)Math.round((double)(y0 - 90) + 23.5);
        int yy = (int)Math.round((double)(y0 + 90) - 23.5);
        int i = 0;
        while (i < 60) {
            g.drawLine(xx, yy1, xx + 2, yy1);
            g.drawLine(xx, yy2, xx + 2, yy2);
            g.drawLine(xx, y, xx + 2, y);
            g.drawLine(xx, yy, xx + 2, yy);
            xx += 6;
            ++i;
        }
        y = y0 - (int)Math.round(this.dec);
        g.setColor(Color.yellow);
        g.fillOval(this.xL + x - Radius, y - Radius, 2 * Radius, 2 * Radius);
        g.setColor(Color.red);
        g.drawOval(this.xL + x - Radius - 1, y - Radius - 1, 2 * Radius + 2, 2 * Radius + 2);
        g.setColor(Color.blue);
        int F = this.dec > 0.0 ? 1 : -1;
        int i2 = -x;
        while (x + i2 < 2 * x0) {
            yy = this.computeLat(i2, this.dec);
            yy1 = this.computeLat(i2 + 1, this.dec);
            g.drawLine(this.xL + x + i2, y0 - yy, this.xL + x + i2 + 1, y0 - yy1);
            if (i2 % 7 == 0) {
                g.drawLine(this.xL + x + i2, y0 - yy, this.xL + x + i2, y0 + F * 90 - 2);
            }
            ++i2;
        }
        g.setColor(Color.black);
        this.longitude = this.xMouse - this.xL - 180;
        this.latitude = 90 - this.yMouse + this.xOben;
        str = String.valueOf((int)Math.abs(this.latitude));
        str = this.latitude > 0.0 ? String.valueOf(str) + " N" : String.valueOf(str) + " S";
        str = String.valueOf(str) + "  " + String.valueOf((int)Math.abs(this.longitude));
        str = this.longitude > 0.0 ? String.valueOf(str) + " E" : String.valueOf(str) + " W";
        this.hoehe = this.computeHeight();
        g.setColor(Color.red);
        if (this.clicked) {
            g.drawString(str, 260, 245);
            str = "Elev.  = " + String.valueOf((int)Math.round(this.hoehe)) + " deg";
            g.drawString(str, 260, 260);
            g.drawOval(this.xMouse - 3, this.yMouse - 3, 6, 6);
        } else {
            g.drawString("Click the map to see", 250, 245);
            g.drawString("the shadow", 250, 260);
            g.drawString("and more !", 250, 275);
        }
        double azimuth = this.computeAzimut();
        if (this.clicked) {
            str = "Azim. = " + String.valueOf((int)Math.round(azimuth)) + " deg";
            g.drawString(str, 260, 275);
        }
        if (this.hoehe > 0.0 && this.clicked) {
            double gnomon = 50.0 / Math.tan(this.K * this.hoehe);
            int yGnomon = (int)Math.round(gnomon * Math.cos(this.K * (azimuth -= 180.0)));
            int xGnomon = (int)Math.round(gnomon * Math.sin(this.K * azimuth));
            g.drawLine(this.xMouse, this.yMouse, this.xMouse + xGnomon, this.yMouse - yGnomon);
        }
    }

    public boolean action(Event event, Object eventobject) {
        if (event.target == this.timeChoice) {
            this.timeString = this.timeChoice.getSelectedItem();
            this.locOffset = this.locOffset = this.time.getTimeZone(this.timeString);
            this.timeChoice.select(this.timeString);
        }
        this.g.clipRect(0, 0, this.size().width, this.size().height);
        this.repaint();
        return true;
    }

    public boolean mouseDown(Event event, int x, int y) {
        this.xMouse = x;
        this.yMouse = y;
        if (this.xMouse >= this.xL && this.xMouse <= this.xL + 360 && this.yMouse >= this.xOben && this.yMouse <= this.xOben + 180) {
            this.clicked = true;
            this.repaint();
            return true;
        }
        return false;
    }
}

