/* Quelle: Boone, Mark: Learn Java on the Macintosh, Addison-Wesley
/* -------------------------------------------------------------
Java's classes: Applet    (applet)
                Event     (awt)     user-generated action
                Graphics  (awt)     used for drawing
                Color     (awt)     defines colors
                Choice    (awt)     shape and color selection choices
                Vector    (util)    list of shapes

Custom classes: SimpleDraw
                Circle              defines and draws circles
                Square              defines and draws squares
				Shape				a common ancestor for circles and squares
------------------------------------------------------------- */

import java.applet.Applet;
import java.util.*;
import java.awt.*;

public class SimpleDraw extends Applet {
   Vector  drawnShapes;
   Choice  shapeChoice;
   Choice  colorChoice;
   
   /** Create the Graphic User Interface (GUI). */
   public void init() {
      drawnShapes = new Vector();
      
      shapeChoice = new Choice();
      shapeChoice.addItem("Circle");
      shapeChoice.addItem("Square");
      add(shapeChoice);
      
      colorChoice = new Choice();
      colorChoice.addItem("Red");
      colorChoice.addItem("Green");
      colorChoice.addItem("Blue");
      add(colorChoice);
   }
   
   /** Draw all the shapes. */
   public void paint(Graphics g) {
      Shape s;
      int numShapes;
      
      numShapes = drawnShapes.size();
      for (int i = 0; i < numShapes; i++) {
      	
      	// casting (Typen-Konvertierung): circle -> shape bzw. square -> shape
         s = (Shape)drawnShapes.elementAt(i); 
         
         // When the shape draws, circles and squares each invoke their own
         // draw method, depending on which shape this is.
         s.draw(g);  
      }
   }
   
   /** Create a new shape. */
   public boolean mouseUp(Event e, int x, int y) {
   
      Shape s;  // This shape will be either a circle or a square.
   
      String shapeString = shapeChoice.getSelectedItem();
      String colorString = colorChoice.getSelectedItem();
      
      if (shapeString.equals("Circle"))
         s = new Circle();
      else
         s = new Square();
      
      if (colorString.equals("Red"))
         s.color = Color.red;
      else if (colorString.equals("Green"))
         s.color = Color.green;
      else
         s.color = Color.blue;
         
      s.x = x;
      s.y = y;
      
      drawnShapes.addElement(s);
      
      repaint();
      
      return true;
   }
}

/** Shapes provide common characteristics for the circle and square. */
abstract class Shape {
   static public final int shapeRadius = 20;
   
   Color color;
   int x;
   int y;
   
   abstract void draw(Graphics g);
}

/** Draws and maintains circle information. */
class Circle extends Shape {
   void draw(Graphics g) {
      g.setColor(this.color);
      g.fillOval(this.x - shapeRadius, this.y - shapeRadius, shapeRadius * 2, shapeRadius * 2);
   }
}

/** Draws and maintains square information. */
class Square extends Shape{
   void draw(Graphics g) {
      g.setColor(this.color);
      g.fillRect(this.x - shapeRadius, this.y - shapeRadius, shapeRadius * 2, shapeRadius * 2);  
   }
}
